import java.io.*;
import java.util.*;
import java.math.*;

public class K implements Runnable {
	private static BufferedReader in;
	private static StringTokenizer st;
	private static PrintWriter out;

	private void solveOne(String s) {
		int n = 7;
		int total = (1 << n);
		if (s.length() != total)
			throw new AssertionError();
		final int[][] brothers = { { 4, 3, 5, 0, 2, 6, 1 },
				{ 0, 2, 6, 1, 8, 18, 7 }, { 3, 10, 0, 2, 9, 1, 8 },
				{ 12, 11, 4, 3, 10, 0, 2 }, { 13, 12, 14, 4, 3, 5, 0 },
				{ 14, 4, 15, 5, 0, 16, 6 }, { 5, 0, 16, 6, 1, 17, 18 } };
		int[] go = new int[1 << 19];
		for (int mask = 0; mask < (1 << 19); mask++) {
			int newMask = 0;
			for (int j = 0; j < 19; j++) {
				if (j < n) {
					int goMask = 0;
					for (int k = 0; k < n; k++) {
						if (checkBit(mask, brothers[j][k])) {
							goMask |= (1 << k);
						}
					}
					if (s.charAt(goMask) == '1')
						newMask |= (1 << j);
				} else {
					newMask |= (1 << j) & mask;
				}
			}
			go[mask] = newMask;
		}
		boolean ok = true;
		for (int i = 0; i < (1 << 19); i++) {
			if (go[i] != go[go[i]]) {
				ok = false;
			}
		}
		out.println(ok ? "yes" : "no");
	}

	private boolean checkBit(int mask, int i) {
		return ((mask >> i) & 1) != 0;
	}

	private void solve() throws IOException {
		while (true) {
			String s = nextToken();
			if (s.equals("#"))
				break;
			solveOne(s);
		}
	}

	public void run() {
		final String className = this.getClass().getName().toLowerCase();

		try {
			try {
				in = new BufferedReader(new FileReader(className + ".in"));
				out = new PrintWriter(new FileWriter(className + ".out"));
			} catch (FileNotFoundException e) {
				in = new BufferedReader(new InputStreamReader(System.in));
				out = new PrintWriter(System.out);
			}

			solve();

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public static void main(String[] args) {
		new K().run();
		// new Thread(null, new Template(), "Template", (1L << 24)).start();
	}

	private String nextToken() throws IOException {
		while (st == null || !st.hasMoreTokens()) {
			String line = in.readLine();
			if (line == null) {
				return null;
			}
			st = new StringTokenizer(line);
		}
		return st.nextToken();
	}

	private int nextInt() throws IOException {
		return Integer.parseInt(nextToken());
	}

	private long nextLong() throws IOException {
		return Long.parseLong(nextToken());
	}

	private double nextDouble() throws IOException {
		return Double.parseDouble(nextToken());
	}

}
